package cn.ninegame.ad.demo.activity;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;

import cn.ninegame.ad.demo.R;
import cn.ninegame.ad.demo.config.NGAdManagerHolder;
import cn.ninegame.ad.demo.util.Const;
import cn.ninegame.ad.demo.util.UIUtil;
import cn.sirius.nga.NGAdSdk;
import cn.sirius.nga.ad.NGAdBase;
import cn.sirius.nga.ad.NGAdError;
import cn.sirius.nga.ad.NGSplashAd;
import cn.sirius.nga.config.AdPlacement;
import cn.sirius.nga.config.NGAdConfig;

/**
 * 这个类展示了，开屏广告与联运SDK初始化时机的流程
 *
 * 时机流程图，请阅读文档：与网游联运SDK集成时机
 */
public class GameInitActivity extends Activity {
    private static final String TAG = "GameActivity";

    @Override
    public void onCreate(Bundle b) {
        super.onCreate(b);
        this.setContentView(R.layout.mediation_activity_splash);

        mSplashContainer = findViewById(R.id.fl_content);

        // 1. 初始化广告SDK
        NGAdSdk.init(GameInitActivity.this, new NGAdConfig.Builder()
                .setAppId("xxxx")
                .setAppName("APP测试媒体")
                //.setDebug(true)
                .build(), new NGAdSdk.Callback() {
            @Override
            public void success() {
                // 2. 广告SDK 初始化成功，开始展示广告
                NGAdSdk.start(new NGAdSdk.Callback() {
                    @Override
                    public void success() {
                        // 3. 加载并展示开屏广告
                        loadAndShowSplashAd(); // 3.1 进这个方法内部监听#mNGSplashAdListener，在开屏展示完成后，初始化UCGameSDK
                    }

                    @Override
                    public void fail(int code, String msg) {
                        // 广告SDK load 失败，游戏执行兜底逻辑：比如初始化UCGameSDK
                    }
                });
            }

            @Override
            public void fail(int code, String msg) {
                // 广告SDK 初始化失败，游戏执行兜底逻辑：比如初始化UCGameSDK
            }
        });

    }

    private FrameLayout mSplashContainer;

    private NGSplashAd mSplashAd;

    private NGAdBase.SplashAdListener mNGSplashAdListener;

    private NGSplashAd.SplashAdListener mNGSplashInteractionListener;

    private void loadAndShowSplashAd() {
        // 注意：这里，游戏可以做个时间监听，比如启动到开屏广告为5s，如果超过5s，则可以不展示广告，然后去执行兜底逻辑。
        AdPlacement adPlacement = new AdPlacement.Builder()
                .setCodeId("xxxx")
                .setImageAcceptedSize(UIUtil.getScreenWidthInPx(this), UIUtil.getScreenHeightInPx(this))
                .build();

        NGAdBase adBaseLoader = NGAdManagerHolder.get().createAdNative(this);

        initListeners();

        // 4. 请求加载开屏广告
        adBaseLoader.loadSplashAd(adPlacement, mNGSplashAdListener, 3500);
    }

    private void initListeners() {
        // 广告加载监听器
        this.mNGSplashAdListener = new NGAdBase.SplashAdListener() {
            @Override
            public void onSplashRenderSuccess(NGSplashAd ad) {
                /* 5、渲染成功后，展示广告 */
                // 注意：这里，可以配合时间监听，比如启动到开屏广告为5s，如果超过5s，则可以不展示广告，然后去执行兜底逻辑。

                // 注意，为防止广告服务器对尺寸的要求，宽高默认为match_parent，全屏展示，不要在广告上有任何遮挡View
                mSplashAd = ad;
                ad.setSplashAdListener(mNGSplashInteractionListener);
                View splashView = ad.getSplashView();
                UIUtil.removeFromParent(splashView);
                mSplashContainer.removeAllViews();
                mSplashContainer.addView(splashView);
            }

            @Override
            public void onSplashLoadSuccess(NGSplashAd ad) {
                // 这里加载成功，但还没有渲染，不可展示
            }

            @Override
            public void onSplashLoadFail(NGAdError ngAdError) {
                // 广告加载失败，游戏执行兜底逻辑：比如初始化UCGameSDK
            }

            @Override
            public void onSplashRenderFail(NGSplashAd ad, NGAdError ngAdError) {
                // 广告渲染失败，游戏执行兜底逻辑：比如初始化UCGameSDK
            }
        };

        // 广告展示监听器
        this.mNGSplashInteractionListener = new NGSplashAd.SplashAdListener() {
            @Override
            public void onSplashAdShow(NGSplashAd ad) {
                // 广告成功展示（即开始展示），通常不需要处理
            }

            @Override
            public void onSplashAdClick(NGSplashAd ad) {
                Log.d(Const.TAG, "splash click");
                // 监听到点击事件，暂缓下一步逻辑，展示点击结果页面
            }

            @Override
            public void onSplashAdClose(NGSplashAd ad, int closeType) {
                // 最后一步：开屏广告展示成功结束
                mSplashContainer.removeAllViews(); // 移除（如果开屏广告的加载页面不是独立Activity，则需要移除防止遮罩游戏）

                // 开始初始化UCGameSDK
                // ucNetworkAndInitUCGameSDK();
                // UCGameSdk.defaultSdk().registerSDKEventReceiver(receiver);

            }
        };
    }
}
